//----------------------------------------------------------------------------//
//- CadAnzahlEtiketten.pas ---------------------------------------------------//
//----------------------------------------------------------------------------//

//- Beschreibung -------------------------------------------------------------//
// Dialog, bei dem der User nach der Anzahl der fehlenden Etiketten auf dem   //
// Etikettenbogen gefragt wird                                                //
// -> Abgeleitet von TCaDlgBaseDialog                                         //
//----------------------------------------------------------------------------//

unit CadAnzahlEtiketten;

//------------------------------------------------------------------------------

interface

//------------------------------------------------------------------------------

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, CadBaseDialog, StdCtrls, Spin;

//------------------------------------------------------------------------------

type
  TCaDlgAnzahlEtiketten = class(TCaDlgBaseDialog)

    //--------------------------------------------------------------------------

    m_GrpAnzahl   : TGroupBox;
    m_EdtAnzahl   : TSpinEdit;
    m_LblAnzahl   : TLabel;

    //--------------------------------------------------------------------------

    procedure FormShow(Sender: TObject);

  //----------------------------------------------------------------------------

  private
    function PrvGetFehlendeEtiketten: Integer;

  //----------------------------------------------------------------------------

  public
    property iAnzahlFehlendeEtiketten: Integer read PrvGetFehlendeEtiketten;

  //----------------------------------------------------------------------------

  end; // TCaDlgAnzahlEtiketten

//------------------------------------------------------------------------------

var
  CaDlgAnzahlEtiketten: TCaDlgAnzahlEtiketten;

//------------------------------------------------------------------------------

implementation

//------------------------------------------------------------------------------

{$R *.dfm}

//------------------------------------------------------------------------------

procedure TCaDlgAnzahlEtiketten.FormShow(Sender: TObject);
begin
  inherited;
  // Das Eingabefeld leeren
  m_EdtAnzahl.Value := 0;
  // Den Fokus zu beginn auf das Eingabefeld setzen
  m_EdtAnzahl.SetFocus;
end; // TCaDlgAnzahlEtiketten.FormShow

//------------------------------------------------------------------------------

function TCaDlgAnzahlEtiketten.PrvGetFehlendeEtiketten: Integer;
(*
  Auslesen der Anzahl fehlenden Etiketten
*)
begin
  Result := m_EdtAnzahl.Value;
end; // TCaDlgAnzahlEtiketten.PrvGetFehlendeEtiketten

//------------------------------------------------------------------------------

end. //  CadAnzahlEtiketten
